#include "Keyboard.h"

#define buttonPin 2
#define LED  5
#define pir  7

int detect = LOW;
int pirState = LOW;
int buttonState = LOW;
int buttonRead = LOW;
int bounce = 200;		// Button de-bounce time in ms
int RxLED = 17;

void setup()
{
  Serial.begin(9600);
  Keyboard.begin();

  pinMode(buttonPin, INPUT);	// set button mode
  pinMode(LED, OUTPUT);		// initialise LED
  digitalWrite(LED, HIGH);
  digitalWrite(RxLED, HIGH);	// turn off internal receive data LED
  pinMode(pir, INPUT);		// initialise PIR

  Serial.print("Calibraring Sensor for 15 seconds ");
  for (int i = 0; i <= 15; i++) {
    Serial.print(".");
    delay(1000);
  }
  Serial.println("Sensor ready.");
  Serial.println("Scanning");
}

void loop()
{
  if (buttonState == LOW) {			// if LOW then the system is active
    detect = digitalRead(pir);			// read PIR input value
    if (detect == HIGH) {			// motion detected on HIGH
      digitalWrite(RxLED, LOW);			// turn receive LED on when motion detected
      if (pirState == LOW) {
        pirState = HIGH;			// toggle PIR state
        Serial.println("Motion detected");	// only print on the output change, not the state

        // Send keyboard sequence to shift display pages to the left
        Keyboard.press(KEY_LEFT_GUI);
        Keyboard.press(KEY_LEFT_CTRL);
        Keyboard.press(KEY_LEFT_ARROW);
        delay(100);
        Keyboard.releaseAll();
      }
    } else {
      if (pirState == HIGH) {
        pirState = LOW;
        digitalWrite(RxLED, HIGH);
        Serial.println("Scanning");		// only print on the output change, not the state
      }
    }
  }
  buttonRead = digitalRead(buttonPin);
  if (buttonRead == HIGH) {			// button pressed
    buttonState = !buttonState;			// toggle the button state
    digitalWrite(LED, !digitalRead(LED));	// toggle LED - On is system active
    delay(bounce);				// button de-bounce delay
  }
}
